# Mountain View Yoga Studio - Brand Assets

Following the streamlined branding process, I've created sample brand assets for Mountain View Yoga Studio based on their brand personality, color palette, typography, and logo concept.

## Business Card

### Design Elements
- **Front**:
  - Logo (mountain/lotus symbol with wordmark) centered
  - Sage green (#7D9D8C) background with white text
  - Tagline "Find balance, find peace" in Montserrat Light Italic
  
- **Back**:
  - Soft cream (#F8F5F0) background
  - Contact information in Montserrat Regular:
    - Address: 123 Serenity Lane, Mountain View, CA 94040
    - Phone: (555) 123-4567
    - Email: info@mountainviewyoga.com
    - Website: www.mountainviewyoga.com
  - Social media handles in Montserrat Light
  - Small mountain/lotus symbol as a watermark in light sage green

### Practical Considerations
- Standard size: 3.5" x 2"
- Rounded corners for a softer feel
- Matte finish for an eco-friendly appearance
- Adequate white space for a clean, calming look

## Social Media Profile Images

### Profile Picture
- Mountain/lotus symbol only (no text)
- Square format (400x400 pixels)
- Sage green symbol on soft cream background
- Subtle shadow for dimension

### Cover/Banner Image
- Horizontal format (Facebook: 820x312 pixels)
- Soft blue (#A4C1D7) gradient background
- Full logo positioned on left side
- Tagline "Find balance, find peace" in Playfair Display Italic on right side
- Simple, minimalist mountain silhouette as a subtle background element

## Email Signature

### Design Elements
- Name in Playfair Display Bold (Dark Charcoal)
- Title in Montserrat Light Italic (Sage Green)
- Company name in Playfair Display Regular (Sage Green)
- Contact information in Montserrat Regular (Dark Charcoal)
- Small logo to the left of text
- Horizontal line in Sage Green above social media icons
- Social media icons in Sage Green
- Tagline in Montserrat Light Italic

### Layout
```
[Small Logo] Jane Smith
           Yoga Instructor
           Mountain View Yoga Studio
           
           123 Serenity Lane, Mountain View, CA 94040
           (555) 123-4567 | jane@mountainviewyoga.com
           www.mountainviewyoga.com
           ______________________________
           
           [FB] [IG] [TW]
           
           "Find balance, find peace"
```

## Social Media Post Templates

### Template 1: Quote Posts
- Soft cream background
- Sage green decorative quotation marks
- Quote text in Playfair Display Italic (Dark Charcoal)
- Attribution in Montserrat Light (Sage Green)
- Small logo in bottom right corner
- Thin terracotta border

### Template 2: Class Announcements
- Soft blue background
- Class name in Playfair Display Bold (Sage Green)
- Details (time, instructor, level) in Montserrat Regular (Dark Charcoal)
- Call-to-action button in Terracotta with white Montserrat Semi-Bold text
- Logo in top left corner
- Simple mountain silhouette watermark

### Template 3: Wellness Tips
- White background
- "WELLNESS TIP" header in Montserrat Semi-Bold (Terracotta)
- Tip title in Playfair Display Regular (Sage Green)
- Tip content in Montserrat Regular (Dark Charcoal)
- Numbered or bulleted format for easy reading
- Small lotus flower graphic element
- Logo in bottom center

## Letterhead/Document Template

### Design Elements
- Logo centered at top
- Tagline in Montserrat Light Italic below logo
- Thin sage green horizontal line separating header from content
- Contact information in Montserrat Light at bottom
- Subtle mountain silhouette watermark in very light sage green in bottom right corner

### Layout
- Standard 8.5" x 11" size
- 1" margins all around
- Header: 1.5" from top
- Footer: 1" from bottom
- Body text in Montserrat Regular (Dark Charcoal)
- Headings in Playfair Display (Sage Green)

## Brand Style Guide Summary

### Logo
- Primary, horizontal, symbol-only, and wordmark variations
- Clear space requirements
- Minimum size requirements
- Approved color applications

### Color Palette
- Primary: Sage Green (#7D9D8C)
- Secondary: Soft Blue (#A4C1D7)
- Accent: Terracotta (#D5836C)
- Light Neutral: Soft Cream (#F8F5F0)
- Dark Neutral: Deep Charcoal (#3A3E40)

### Typography
- Headings: Playfair Display (various weights)
- Body: Montserrat (various weights)
- Hierarchy system for H1, H2, H3, body text, and accents

### Brand Voice
- Calm, nurturing, professional, approachable
- Focus on inclusivity, balance, and wellbeing
- Avoid jargon, emphasize accessibility of yoga for all

### Imagery Guidelines
- Natural light photography
- Diverse representation of practitioners
- Emphasis on nature elements
- Calm, serene settings
- Avoid overly complex or busy backgrounds

These sample brand assets demonstrate how Mountain View Yoga Studio's brand identity can be consistently applied across various touchpoints, creating a cohesive and professional brand experience for their target audience.

*Note: In a real implementation, this document would include actual design files for each asset. For this sample exercise, we're providing the concept descriptions only.*
