# Mountain View Yoga Studio - Color Palette Selection

Following the streamlined branding process, I've created a color palette for Mountain View Yoga Studio based on their brand personality (calming, nurturing, professional, approachable, eco-friendly) and industry (health & wellness).

## Selected Color Palette

### Primary Brand Color
- **Sage Green**: #7D9D8C
- Represents: Growth, harmony, nature, balance
- Usage: Main brand color for logo, headers, and primary elements

### Secondary Brand Color
- **Soft Blue**: #A4C1D7
- Represents: Tranquility, trust, peace, clarity
- Usage: Supporting elements, backgrounds, secondary sections

### Accent Color
- **Warm Terracotta**: #D5836C
- Represents: Energy, warmth, grounding
- Usage: Call-to-action buttons, highlights, emphasis

### Light Neutral
- **Soft Cream**: #F8F5F0
- Represents: Purity, space, openness
- Usage: Backgrounds, negative space, text areas

### Dark Neutral
- **Deep Charcoal**: #3A3E40
- Represents: Stability, professionalism, focus
- Usage: Text, outlines, footers

## Color Palette Rationale

This palette was selected because:

1. **Industry Alignment**: The green and blue tones are commonly associated with wellness, health, and tranquility - perfect for a yoga studio.

2. **Brand Personality Match**: 
   - The soft, muted tones reflect the "calming" and "nurturing" aspects
   - The professional charcoal adds the "professional" element
   - The warm terracotta accent adds an "approachable" quality
   - The natural tones support the "eco-friendly" value

3. **Target Audience Appeal**: The sophisticated yet approachable palette will resonate with the target demographic of health-conscious adults.

4. **Versatility**: This palette works well across digital and print applications, from website to business cards to signage.

5. **Differentiation**: While using colors common in the wellness industry, the specific combination helps Mountain View Yoga Studio stand out from competitors.

## Application Guidelines

- Use sage green as the dominant color (approximately 60% of designs)
- Use soft blue as the secondary color (approximately 30% of designs)
- Use terracotta sparingly as an accent (approximately 10% of designs)
- Use cream for backgrounds and breathing space
- Use charcoal for most text to ensure readability

This color palette provides a strong foundation for Mountain View Yoga Studio's brand identity, conveying their values and appealing to their target audience while remaining versatile for all applications.
