# Mountain View Yoga Studio - Typography Selection

Following the streamlined branding process, I've selected typography for Mountain View Yoga Studio based on their brand personality (calming, nurturing, professional, approachable, eco-friendly) and industry (health & wellness).

## Selected Typography

### Heading Font
- **Playfair Display** (Serif)
- Style: Elegant, classic with modern touches
- Usage: Business name, headings, titles, emphasis
- Characteristics: Graceful serifs, good contrast, distinctive character
- Google Fonts Link: [Playfair Display](https://fonts.google.com/specimen/Playfair+Display)

### Body Font
- **Montserrat** (Sans-serif)
- Style: Clean, versatile, highly readable
- Usage: Body text, descriptions, contact information, schedules
- Characteristics: Geometric, neutral, excellent readability at all sizes
- Google Fonts Link: [Montserrat](https://fonts.google.com/specimen/Montserrat)

## Typography Rationale

This font pairing was selected because:

1. **Brand Personality Match**:
   - Playfair Display's elegant serifs convey the "professional" and "nurturing" aspects
   - Montserrat's clean lines support the "approachable" and "calming" qualities
   - Together they create a balanced, harmonious look that reflects yoga philosophy

2. **Industry Appropriateness**:
   - Wellness brands often balance tradition (serif) with modernity (sans-serif)
   - The pairing is sophisticated without being intimidating
   - Both fonts have a balanced, centered quality that aligns with yoga principles

3. **Practical Considerations**:
   - Both fonts are highly readable across digital and print applications
   - They work well in various sizes and weights
   - They're available on Google Fonts (free for commercial use)
   - They pair well together despite being from different font families

4. **Target Audience Appeal**:
   - The combination is sophisticated enough for the middle to upper-income target demographic
   - Not too trendy or too traditional, appealing to the 25-55 age range

## Typography Hierarchy

### Primary Heading (H1)
- Font: Playfair Display
- Weight: Bold
- Size: 32px (web) / 24pt (print)
- Case: Title Case
- Usage: Business name, page titles, main headers

### Secondary Heading (H2)
- Font: Playfair Display
- Weight: Regular
- Size: 24px (web) / 18pt (print)
- Case: Title Case
- Usage: Section headers, important information

### Subheading (H3)
- Font: Playfair Display
- Weight: Italic
- Size: 18px (web) / 14pt (print)
- Case: Sentence case
- Usage: Subsections, emphasis

### Body Text
- Font: Montserrat
- Weight: Regular
- Size: 16px (web) / 11pt (print)
- Case: Sentence case
- Usage: Paragraphs, descriptions, general information

### Accent Text
- Font: Montserrat
- Weight: Light Italic
- Size: 16px (web) / 11pt (print)
- Case: Sentence case
- Usage: Quotes, testimonials, emphasis

### Button/Call to Action
- Font: Montserrat
- Weight: Semi-Bold
- Size: 16px (web) / 12pt (print)
- Case: ALL CAPS
- Usage: Buttons, calls to action, important prompts

This typography selection provides Mountain View Yoga Studio with a versatile, professional, and appropriate font system that will work across all their branding materials while conveying their brand personality.
