# Typography Selection Guide

## Introduction
Typography (the style and appearance of text) is a crucial element of your brand identity. This guide will help you select and use fonts that reflect your brand personality without requiring any technical design knowledge.

## Font Types Explained

### Serif Fonts
- Have small lines or "feet" at the ends of characters
- Convey: Tradition, reliability, respectability, formality
- Examples: Times New Roman, Georgia, Baskerville
- Best for: Law firms, financial institutions, academic organizations, luxury brands

### Sans-Serif Fonts
- Clean, without the small lines at character ends
- Convey: Modern, straightforward, clean, minimal
- Examples: Arial, Helvetica, Open Sans
- Best for: Tech companies, healthcare, startups, contemporary brands

### Script Fonts
- Mimic handwriting or calligraphy
- Convey: Elegance, creativity, personalization
- Examples: Brush Script, Pacifico, Dancing Script
- Best for: Wedding services, boutiques, artistic brands
- Note: Use sparingly and ensure readability

### Display Fonts
- Decorative, distinctive, attention-grabbing
- Convey: Uniqueness, character, specific mood
- Examples: Impact, Rockwell, Lobster
- Best for: Headlines, logos, short text sections
- Note: Not suitable for body text

## Step-by-Step Font Selection

### Step 1: Access Google Fonts
1. Open your web browser
2. Go to [Google Fonts](https://fonts.google.com/)
3. All fonts here are free for commercial use

### Step 2: Select a Heading Font
1. Consider your brand personality from your questionnaire
2. Use the filter options to narrow down choices:
   - Categories (serif, sans-serif, display, handwriting)
   - Properties (thickness, width, slant)
3. Type sample text (like your business name) in the preview box
4. Select 2-3 potential heading fonts by clicking the "+" icon

### Step 3: Select a Body Text Font
1. Your body text font should be highly readable
2. Sans-serif fonts are generally more readable on screens
3. Select 1-2 potential body fonts that complement your heading font
4. Click "View Selected Families" to see your selections together

### Step 4: Test Font Combinations
1. In the selected families panel, try different combinations of your heading and body fonts
2. Good combinations usually pair contrasting fonts (serif heading with sans-serif body, or vice versa)
3. Ensure the fonts have different weights but similar character widths
4. Test readability at different sizes

### Step 5: Finalize Your Selection
1. Choose one heading font and one body font
2. Note the font names for future reference
3. Click "Download" if you want to install them on your computer (optional)

## Font Pairing Examples

### Professional/Corporate
- Heading: Playfair Display (serif)
- Body: Source Sans Pro (sans-serif)

### Creative/Modern
- Heading: Montserrat (sans-serif, bold)
- Body: Lora (serif)

### Friendly/Approachable
- Heading: Quicksand (rounded sans-serif)
- Body: Open Sans (sans-serif)

### Luxury/Elegant
- Heading: Cormorant Garamond (serif)
- Body: Montserrat (sans-serif)

### Casual/Playful
- Heading: Pacifico (script)
- Body: Roboto (sans-serif)

## Typography Hierarchy Guidelines

### Primary Heading (H1)
- Your heading font, largest size
- Used for main titles, headlines
- Example: 24-36px on web

### Secondary Heading (H2)
- Your heading font, medium size
- Used for section titles
- Example: 18-24px on web

### Subheading (H3)
- Your heading font, smaller size
- Used for subsections
- Example: 16-18px on web

### Body Text
- Your body font, standard size
- Used for paragraphs and main content
- Example: 14-16px on web

### Accent Text
- Either font, distinctive treatment
- Used for quotes, callouts, emphasis
- Example: Italics, different color, or slightly larger

## Typography Do's and Don'ts

### Do's
- Limit your selection to 2 fonts (3 maximum)
- Ensure readability across all sizes
- Maintain consistency across all brand materials
- Consider how fonts look on different devices and in print

### Don'ts
- Don't use more than 3 fonts in your brand
- Don't choose overly similar fonts (they should contrast)
- Don't use decorative or script fonts for body text
- Don't use too many different sizes, weights, or styles

## Using Your Fonts in Canva

1. Open Canva and start a new design
2. Click on the "Text" tab
3. If your selected Google Fonts aren't available:
   - Click "Upload" and then "Fonts"
   - Upload the fonts you downloaded from Google Fonts
4. Create text styles for your headings and body text
5. Save these as "Brand Kit" elements if you have Canva Pro

---

This guide is part of your Branding Kit. After selecting your typography, move on to the Logo Creation Guide to continue building your brand identity.
